<?php

/**
 * @package SP Page Builder
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2023 JoomShaper
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

//no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;

$presetsData = SpPageBuilderAddonHelper::getPresets('easystore_common_productlist');

SpAddonsConfig::addonConfig([
    'type'       => 'structure',
    'addon_name' => 'productlist',
    'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_PRODUCT_LIST'),
    'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_PRODUCT_LIST_DESC'),
    'category'   => Text::_('COM_EASYSTORE_ADDON_GROUP_COMMON'),
    'context'    => 'easystore.common',
    'icon'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 5.1h2.9V2.9h2.2V0H0v5.1z" fill="currentColor"></path><path d="M19.7 0h-7.3v2.9h7.3V0z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M26.9 0v2.9h2.2v2.2H32V0h-5.1z" fill="currentColor"></path><path d="M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z" fill="currentColor"></path><path d="M19.7 29.1h-7.3V32h7.3v-2.9z" fill="currentColor"></path></svg>',
    'settings'   => [
        'content' => [
            'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_GENERAL'),
            'fields' => [
                'presets' => [
                    'type'   => 'preset',
                    'title'  => 'Presets',
                    'desc'   => 'Select a preset.',
                    'values' => $presetsData['presets'],
                    'std'    => $presetsData['default_preset'],
                ],
                'grid_columns' => [
                    'type'       => 'slider',
                    'title'      => 'Grid Column',
                    'desc'       => 'Enter number of column',
                    'min'        => 1,
                    'max'        => 6,
                    'responsive' => true,
                    'std'        => ['xl' => '3'],
                    'depends'    => [['enable_scroller', '=', 0]],
                ],
                'gap_x' => [
                    'type'       => 'slider',
                    'title'      => 'Column Gap',
                    'desc'       => 'Enter grid gap',
                    'min'        => 0,
                    'max'        => 100,
                    'responsive' => true,
                    'std'        => ['xl' => '32'],
                ],
                'gap_y' => [
                    'type'       => 'slider',
                    'title'      => 'Row Gap',
                    'desc'       => 'Enter grid gap',
                    'min'        => 0,
                    'max'        => 100,
                    'responsive' => true,
                    'std'        => ['xl' => '32'],
                    'depends'    => [['enable_scroller', '=', 0]],
                ],
                'limit' => [
                    'type'  => 'slider',
                    'title' => 'Limit',
                    'desc'  => 'Total number of products',
                    'min'   => 1,
                    'max'   => 100,
                    'std'   => 16,
                ],
                'source' => [
                    'type'   => 'select',
                    'title'  => 'Source',
                    'desc'   => 'Select a source.',
                    'values' => [
                        'latest'       => 'Latest',
                        'featured'     => 'Featured',
                        'best_selling' => 'Best Selling',
                        'on_sale'      => 'On Sale',
                        'related'      => 'Related',
                        'wishlist'     => 'Wishlist',
                    ],
                    'std' => 'latest',
                ],
                'category' => [
                    'type'    => 'category',
                    'context' => 'com_easystore',
                    'title'   => 'Category',
                    'desc'    => 'Select a category.',
                    'std'     => '',
                ],
                'enable_scroller' => [
                    'type'  => 'checkbox',
                    'title' => 'Enable scroller',
                    'desc'  => 'Enable scroller',
                    'std'   => 0,
                ],
                'items_per_slide' => [
                    'type'       => 'slider',
                    'title'      => 'Slides per item',
                    'desc'       => 'Enter number of items per slide',
                    'min'        => 1,
                    'max'        => 6,
                    'std'        => ['xl' => '4'],
                    'responsive' => true,
                    'depends'    => [['enable_scroller', '=', 1]],
                ],
                'slides_to_scroll' => [
                    'type'       => 'slider',
                    'title'      => 'Number of slides to scroll',
                    'desc'       => 'Enter number of slides to scroll',
                    'min'        => 1,
                    'max'        => 6,
                    'std'        => ['xl' => '1'],
                    'responsive' => true,
                    'depends'    => [['enable_scroller', '=', 1]],
                ],
                'show_indicators' => [
                    'type'    => 'checkbox',
                    'title'   => 'Show indicators',
                    'desc'    => 'Enable showing indicators',
                    'std'     => 1,
                    'depends' => [['enable_scroller', '=', 1]],
                ],
                'pagination' => [
                    'type'    => 'checkbox',
                    'title'   => 'Enable Pagination',
                    'desc'    => 'Enable Pagination',
                    'std'     => 1,
                    'depends' => [['enable_scroller', '=', 0]],
                ],
            ],
        ],

        'item' => [
            'title'  => 'Item',
            'fields' => [
                'padding' => [
                    'type'       => 'padding',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
                    'responsive' => true,
                ],

                'item_options_separator' => [
                    'type' => 'separator',
                ],

                'item_options' => [
                    'type'   => 'buttons',
                    'values' => [
                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NORMAL'), 'value' => 'normal'],
                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HOVER'), 'value' => 'hover'],
                    ],
                    'std' => 'normal',
                ],

                'background' => [
                    'type'    => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
                    'depends' => [['item_options', '=', 'normal']],
                ],

                'border_separator' => [
                    'type'    => 'separator',
                    'depends' => [['item_options', '=', 'normal']],
                ],

                'border' => [
                    'type'       => 'border',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER'),
                    'responsive' => true,
                    'depends'    => [['item_options', '=', 'normal']],
                ],

                'border_radius' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
                    'responsive' => true,
                    'depends'    => [['item_options', '=', 'normal']],
                ],

                'box_shadow' => [
                    'type'    => 'boxshadow',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BOX_SHADOW'),
                    'depends' => [['item_options', '=', 'normal']],
                ],

                // hover state
                'background_hover' => [
                    'type'    => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
                    'depends' => [['item_options', '=', 'hover']],
                ],

                'border_separator_hover' => [
                    'type'    => 'separator',
                    'depends' => [['item_options', '=', 'hover']],
                ],

                'border_hover' => [
                    'type'    => 'border',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER'),
                    'depends' => [['item_options', '=', 'hover']],
                ],

                'border_radius_hover' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
                    'responsive' => true,
                    'depends'    => [['item_options', '=', 'hover']],
                ],

                'box_shadow_hover' => [
                    'type'    => 'boxshadow',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BOX_SHADOW'),
                    'depends' => [['item_options', '=', 'hover']],
                ],
            ],
        ],
    ],
]);
