<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com> . All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class SppagebuilderAddonEasystoreSingleBadge extends SppagebuilderAddons
{
    public function render()
    {
        $settings = $this->addon->settings;

        return EasyStoreHelper::loadLayout(
            'badge',
            [
                'item'        => $this->addon->easystoreItem,
                'badge_text'  => $settings->text ?? 'sale',
                'custom_text' => $settings->custom_text ?? 'Custom',
            ]
        );
    }

    public function css()
    {
        $addon_id  = '#sppb-addon-' . $this->addon->id;
        $settings  = $this->addon->settings;
        $cssHelper = new CSSHelper($addon_id);

        $styleAttributes = [
            'color'            => 'color',
            'background_color' => 'background-color',
            'padding'          => 'padding',
            'border_radius'    => 'border-radius',
        ];

        $css = $cssHelper->generateStyle('.easystore-badge', $settings, $styleAttributes, ['color' => false, 'background_color' => false, 'padding' => false]);
        $css .= $cssHelper->typography('.easystore-badge', $settings, 'typography');
        $css .= $cssHelper->border('.easystore-badge', $settings, 'border');

        return $css;
    }
}
