<?php

use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class SppagebuilderAddonEasystoreSingleQuantity extends SppagebuilderAddons
{
    public function render()
    {
        return EasyStoreHelper::loadLayout(
            'quantity',
            ['item' => $this->addon->easystoreItem]
        );
    }

    public function css()
    {
        $css = '';

        $addon_id  = '#sppb-addon-' . $this->addon->id;
        $settings  = $this->addon->settings;
        $cssHelper = new CSSHelper($addon_id);

        // Input
        $css .= $cssHelper->generateStyle('.easystore-product-quantity', $settings, [
            'radius'     => 'border-radius',
            'background' => 'background',
        ], ['background' => false]);

        $css .= $cssHelper->generateStyle('.easystore-product-quantity', $settings, [
            'width'  => 'width',
            'height' => 'height',
            'color'  => 'color',
        ], ['color' => false]);

        $css .= $cssHelper->typography('.easystore-product-quantity', $settings, 'typography');
        $css .= $cssHelper->border('.easystore-product-quantity', $settings, 'border');

        // button
        $css .= $cssHelper->generateStyle('.easystore-quantity-selector-btn', $settings, [
            'button_width'     => 'width',
            'button_icon_size' => 'font-size',
            'button_color'     => 'color',
        ], ['button_color' => false]);

        $css .= $cssHelper->generateStyle('.easystore-quantity-selector-btn:hover', $settings, [
            'button_color_hover' => 'color',
        ], false);

        return $css;
    }
}
